#!/system/bin/sh

# sky(factory.tests)
FACTORYENABLED=`getprop persist.sys.factory.mode`
if [ $FACTORYENABLED = "true" ]; then
	echo "\n\nWelcome to Android Factory Tests.\n\n" > /dev/kmsg
	setprop service.factory.tests true
else
	echo "\n\nWelcome to Android.\n\n" > /dev/kmsg
fi

# sky(mv2pixat.Attotv)
SKYTVENABLED=`getprop persist.skytv.enable`
if [ $SKYTVENABLED = "true" ]; then
	echo "skytv.enabled" > /dev/kmsg
	setprop service.skytv.enable true
fi

# sky(towntvforkc)
# only rftesttools application
RFTESTTOOL=`getprop persist.sys.rftesttool`
if [ $RFTESTTOOL = "true" ]; then
	echo "RFTESTTOOL enabled." > /dev/kmsg
	setprop sys.rftesttool.enable true
fi

# wait android boot complete
BOOT_PROPERTY_NAME="sys.boot_completed"
# wait android boot complete
while [ -z $(getprop $BOOT_PROPERTY_NAME) ]; do
	sleep 1
#	echo "ghost: waiting" > /dev/kmsg
done

# sky(AiMic) unused oreo
EXISTLINUX=`getprop persist.sys.ghost.linux`
if [ $EXISTLINUX = on ]; then
	echo "ghost: checking install." > /dev/kmsg
	# hychoi(---> for eapand internal storage(microsd))
	INTERNALUUID=$(mount | busybox awk '{printf("%s\n",$0)}' | busybox awk '/expand/' | busybox awk '/ext4/' | busybox awk '{printf("%s\n",$3)}' |  busybox cut -c13-48)
	if [ $INTERNALUUID ];then
		echo "[INTERNALUUID] is $INTERNALUUID" > /dev/kmsg
		umount /mnt/runtime/default/emulated
		umount /storage/emulated
		umount /mnt/runtime/read/emulated
		umount /mnt/runtime/write/emulated

		#	mount -t sdcardfs /mnt/expand/$INTERNALUUID/media /mnt/runtime/default/emulated -o defaults,noatime
		mount -t sdcardfs /mnt/expand/$INTERNALUUID/media /storage/emulated -o defaults,noatime
		mount -t sdcardfs /mnt/expand/$INTERNALUUID/media /mnt/runtime/read/emulated -o defaults,noatime
		mount -t sdcardfs /mnt/expand/$INTERNALUUID/media /mnt/runtime/write/emulated -o defaults,noatime
		setprop persist.sys.expand.uuid $INTERNALUUID
	else
	    setprop persist.sys.expand.uuid none
	fi

	# hychoi(---> for linux version)
	if [ -f "/data/linux/linux.txt" ]; then
		VERSIONLINUX=`getprop persist.sys.version.linux`
	    VERSIONLINUX2=$(cat '/data/linux/linux.txt' | busybox awk '{ split($0,arr,"="); printf("%s\n",arr[2]); }')
		echo "ghost: ver.$VERSIONLINUX2" > /dev/kmsg
		setprop persist.sys.version.linux $VERSIONLINUX2
	fi

	# hychoi(---> for linux)
	setprop persist.sys.ghost.running none
fi

PRODUCTTYPE=`getprop ro.product.type`
if [ $PRODUCTTYPE = ott ]; then
	echo "oscam: ottbox." > /dev/kmsg
else
	OSCAM_SYSTEMDIR=/system/oscam
	OSCAM_DATADIR=/data/oscam
	OSCAM_SAMBADIR=/mnt/oscam
	if [ -d $OSCAM_SYSTEMDIR ]; then
		echo "oscam: mkdir for samba." > /dev/kmsg
		busybox mkdir -p $OSCAM_SAMBADIR
		busybox mount -o bind $OSCAM_DATADIR $OSCAM_SAMBADIR
	fi
fi

if [ $EXISTLINUX = on ]; then

    # sleep 30sec, waiting external disk mounted
    # sleep 30
	echo "ghost: linux boot started." > /dev/kmsg

	# zram enable 800m
	echo "ghost: make 800m zram started." > /dev/kmsg
	echo 1 > /sys/block/zram0/reset
	echo 838860800 > /sys/block/zram0/disksize
	mkswap /dev/block/zram0
	swapon /dev/block/zram0
    echo 100 > /proc/sys/vm/swappiness
	echo "ghost: make 800m zram finished." > /dev/kmsg
    # run internal linux
    if [ -f /data/linux/linux.txt ]; then
		echo "ghost: linux init from internal started." > /dev/kmsg
		ROOT=/data/linux
		/system/xbin/su root /data/init.ghost.linux
    	setprop persist.sys.ghost.running Internal
        setprop persist.sys.ghost.root $ROOT
        setprop persist.sys.ghost.path $ROOT
		echo "ghost: linux init from internal finished." > /dev/kmsg
	fi

		LINUXHOSTNAME=`hostname`
		if [ "`grep $LINUXHOSTNAME /system/etc/hosts -c`" == "0" ]; then
			mount -o rw,remount /system
			busybox sed -i "s/127.0.0.1\s\{1,\}localhost/127.0.0.1\tlocalhost\t$LINUXHOSTNAME/" /system/etc/hosts
			mount -o ro,remount /system
		fi
	echo "ghost: linux boot finished." > /dev/kmsg
fi

exit 1

